<?php
/**
 * Install File
 * Does the stuff for the specific extensions
 *
 * @package         Sliders
 * @version         4.1.3
 *
 * @author          Peter van Westen <peter@nonumber.nl>
 * @link            http://www.nonumber.nl
 * @copyright       Copyright © 2015 NoNumber All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

defined('_JEXEC') or die;

class extensionsInstaller extends NoNumberInstallerInstaller
{
	var $name = 'Sliders';
	var $alias = 'sliders';

	function install(&$states, &$ext)
	{
		$ext = $this->name . ' (editor button & system plugin)';

		// SYSTEM PLUGIN
		$states[] = $this->installExtension($states, $this->alias, 'System - NoNumber ' . $this->name, 'plugin');

		// EDITOR BUTTON PLUGIN
		$states[] = $this->installExtension($states, $this->alias, 'Button - NoNumber ' . $this->name, 'plugin', array('folder' => 'editors-xtd'));
	}

	// Stuff to do before installation / update
	function beforeInstall()
	{
		// rename slider to sliders
		$old = 'slider';
		$new = 'sliders';
		if (is_dir(JPATH_PLUGINS . '/system/' . $old))
		{
			$query = "UPDATE `#__extensions`
			SET	`name` = replace(`name`, " . $this->db->quote(strtoupper($old)) . "," . $this->db->quote(strtoupper($new)) . "),
			`element` = " . $this->db->quote($new) . ",
			`manifest_cache` = replace(`manifest_cache`, " . $this->db->quote(strtoupper($old)) . "," . $this->db->quote(strtoupper($new)) . "),
			`params` = replace(replace(replace(`params`,
				" . $this->db->quote('slider_') . ", " . $this->db->quote('') . "),
				" . $this->db->quote('tag_slidelink') . ", " . $this->db->quote('tag_link') . "),
				" . $this->db->quote('slidelinkscroll') . ", " . $this->db->quote('linkscroll') . ")
			WHERE `element` = " . $this->db->quote($old);
			$this->db->setQuery($query);
			$this->db->execute();

			if (is_dir(JPATH_PLUGINS . '/system/' . $new))
			{
				$f = JPATH_PLUGINS . '/system/' . $old;
				if (JFolder::exists($f))
				{
					JFolder::delete($f);
				}
				$f = JPATH_PLUGINS . '/editors-xtd/' . $old;
				if (JFolder::exists($f))
				{
					JFolder::delete($f);
				}
				$f = JPATH_SITE . '/media/' . $old;
				if (JFolder::exists($f))
				{
					JFolder::delete($f);
				}

				// Delete plugin language files
				$lang_folder = JPATH_ADMINISTRATOR . '/language';
				$languages = JFolder::folders($lang_folder);
				$files = array('plg_editors-xtd_' . $old, 'plg_system_' . $old);
				foreach ($languages as $lang)
				{
					foreach ($files as $file)
					{
						$f = $lang_folder . '/' . $lang . '/' . $lang . '.' . $file . '.ini';
						if (JFile::exists($f))
						{
							JFile::delete($f);
						}
						$f = $lang_folder . '/' . $lang . '/' . $lang . '.' . $file . '.sys.ini';
						if (JFile::exists($f))
						{
							JFile::delete($f);
						}
					}
				}
			}
			else
			{
				JFolder::move($old, $new, JPATH_PLUGINS . '/editors-xtd');
				JFolder::move($old, $new, JPATH_PLUGINS . '/system');
				JFolder::move($old, $new, JPATH_SITE . '/media');

				JFile::move($old . '.php', $new . '.php', JPATH_PLUGINS . '/editors-xtd/' . $new);
				JFile::move($old . '.xml', $new . '.xml', JPATH_PLUGINS . '/editors-xtd/' . $new);
				JFile::move($old . '.php', $new . '.php', JPATH_PLUGINS . '/system/' . $new);
				JFile::move($old . '.xml', $new . '.xml', JPATH_PLUGINS . '/system/' . $new);

				// Delete plugin language files
				$lang_folder = JPATH_ADMINISTRATOR . '/language';
				$languages = JFolder::folders($lang_folder);
				foreach ($languages as $lang)
				{
					JFile::move($lang_folder . '/' . $lang . '/' . $lang . '.plg_editors-xtd_' . $old . '.ini', $lang_folder . '/' . $lang . '/' . $lang . '.plg_editors-xtd_' . $new . '.ini');
					JFile::move($lang_folder . '/' . $lang . '/' . $lang . '.plg_editors-xtd_' . $old . '.sys.ini', $lang_folder . '/' . $lang . '/' . $lang . '.plg_editors-xtd_' . $new . '.sys.ini');
					JFile::move($lang_folder . '/' . $lang . '/' . $lang . '.plg_system_' . $old . '.ini', $lang_folder . '/' . $lang . '/' . $lang . '.plg_system_' . $new . '.ini');
					JFile::move($lang_folder . '/' . $lang . '/' . $lang . '.plg_system_' . $old . '.sys.ini', $lang_folder . '/' . $lang . '/' . $lang . '.plg_system_' . $new . '.sys.ini');
				}
			}
		}
	}

	// Stuff to do after installation / update
	function afterInstall()
	{
		// disable possible remaining old tabber plugins
		$query = "UPDATE `#__extensions`
		SET	`enabled` = 0
		WHERE `element` = " . $this->db->quote('slider');
		$this->db->setQuery($query);
		$this->db->execute();
	}
}
